#ifndef CONN_H
#define CONN_H

#include <netinet/in.h>
#include <stdio.h>
#include "config.h"
#include "stream.h"

/* connid holds all information required to identify a particular connection */
struct connid {
	struct in_addr ipsrc;
	struct in_addr ipdst;
	u_int16_t tcpsrc;
	u_int16_t tcpdst;
};

/* holds a list of received fragments for a connection */
struct fragment {
	u_int32_t seq;
	u_int32_t size;
	u_char *data;
	struct fragment *next;
};

/* holds a connection (each direction of a tcp session is a connection) */
struct connection {
	struct connid cid;
	struct fragment *frags;
	u_int32_t seq;
	u_int32_t size;
	time_t time;
	struct stream stream;
	struct connection *next;
};

void connInit();
void connKill();

void connAdd(struct connid *cid, u_int32_t seq);
void connDelete(struct connid *cid, u_int32_t seq);
void connData(struct connid *cid, u_int32_t seq, u_char *data, u_int32_t len);

void connTwin(struct connid *twin, struct connid *cid);

#endif
