/*
 * HTTPSniff v0.1 - HTTP Response Sniffer
 * frag.c
 * (C)2004 Michael Poppitz
 *
 * Management functions for connection TCP fragments.
 *
 */
 
#include <string.h>

#include "frag.h"

struct fragment *fragFind(struct connection *conn, u_int32_t seq) {
	struct fragment *frag;
	
	for (frag = conn->frags; frag; frag = frag->next)
		if (frag->seq == seq)
			return (frag);

	return (NULL);
}

void fragAdd(struct connection *conn, u_int32_t seq, u_char *packet, u_int32_t len) {
	struct fragment *frag, *tmp;
	
	// populate fragment structure
	frag = malloc(sizeof(struct fragment));
	if (!frag) {
		perror("fragAdd(): Cannot add fragment");
		return;
	}
	frag->data = malloc(len);
	if (!frag->data) {
		free(frag);
		perror("fragAdd(): Cannot add fragment");
		return;
	}
	memcpy(frag->data, packet, len);
	frag->size = len;
	frag->seq = seq;
	frag->next = NULL;
	
	// store fragment in chain
	if (!conn->frags) {
		conn->frags = frag;
	} else {
		for (tmp = conn->frags; tmp->next; tmp = tmp->next);
		tmp->next = frag;
	}
}

/* deletes all fragments which are obsolete by given sequence */
void fragDelete(struct connection *conn, u_int32_t seq) {
	struct fragment *cur, *last, *next;
	
	last = NULL;
	for (cur = conn->frags; cur; cur = next) {
		if (cur->seq <= seq) {
			if (last) {
				last->next = cur->next;
			} else {
				conn->frags = cur->next;
			}
			next = cur->next;
			free(cur->data);
			free(cur);
		} else {
			next = cur->next;
			last = cur;
		}
	}
}
