/*
 * HTTPSniff v0.1 - HTTP Response Sniffer
 * main.c
 * (C)2004 Michael Poppitz
 *
 * This file contains the command line parser and help page.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "config.h"
#include "sniff.h"

#define MODE_AUTO 0
#define MODE_FILE 1
#define MODE_DEV 2

void mainHelp(char *name) {
	printf(
		"\n"
		"Usage: %s [<options>] <name>\n"
		"\n"
		"Where <options> are:\n"
		"	-i	force <name> to be treated as network interface\n"
		"	-f	force <name> to be treated as dump file\n"
		"	-v	verbose - additional v increase output further\n"
		"	-q	quiet - additional q decrease output further\n"
		"	-h	this help page\n"
		"\n"
		,
		name
	);
	exit(EXIT_FAILURE);
}

int main(int argc, char **argv) {
	int i, j, mode;
	char *name;
	
	debug = 1;
	mode = MODE_AUTO;

	if (argc < 2)
		mainHelp(argv[0]);
	
	name = argv[argc - 1];
		
	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			for (j = 1; j < strlen(argv[i]); j++) {
				switch (argv[i][j]) {
					case 'f':
						if (mode == MODE_DEV) {
							printf("FATAL: -f and -i must not be used together.\n");
							mainHelp(argv[0]);
						}
						mode = MODE_FILE;
						break;
					
					case 'h':
						mainHelp(argv[0]);
						break;
	
					case 'i':
						if (mode == MODE_FILE) {
							printf("FATAL: -f and -i must not be used together.\n");
							mainHelp(argv[0]);
						}
						mode = MODE_DEV;
						break;

					case 'q':
						if (debug > 0) debug--;
						break;

					case 'v':
						debug++;
						break;
	
					default:
						printf("FATAL: Invalid option: %s\n", argv[i]);
						mainHelp(argv[0]);
						break;
				}
			}
		}
	}
	
	sniffInit();
	
	if (mode == MODE_AUTO || mode == MODE_FILE) {
		if (debug > 0) printf("Trying to read from file '%s'...\n", name);
		if (sniffFile(name)) {
			if (debug > 0) printf("Failed.\n");
			if (mode != MODE_AUTO) return (EXIT_FAILURE);
		} else {
			sniffKill();
			if (debug > 0) printf("Finished.\n");
			return (EXIT_SUCCESS);
		}
	}
		
	if (mode == MODE_AUTO || mode == MODE_DEV) {
		if (debug > 0) printf("Trying to read from device '%s'...\n", name);
		if (sniffDevice(name)) {
			if (debug > 0) printf("Failed.\n");
			return (EXIT_FAILURE);
		} else {
			sniffKill();
			if (debug > 0) printf("Finished.\n");
			return (EXIT_SUCCESS);
		}
	}

	return (EXIT_FAILURE); // make compiler happy
}
