----------------------------------------------------------------------------------
-- crypt.vhd
--
-- Copyright (C) 2006 Michael Poppitz
-- 
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or (at
-- your option) any later version.
--
-- This program is distributed in the hope that it will be useful, but
-- WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along
-- with this program; if not, write to the Free Software Foundation, Inc.,
-- 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
--
----------------------------------------------------------------------------------
--
-- Details: http://www.sump.org/projects/password/
--
-- Performs the 25 rounds of DES with the given key
-- and compares the result with the provided target.
--
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity crypt is
    Port (
			  key : in  STD_LOGIC_VECTOR (0 to 55);
           salt : in  STD_LOGIC_VECTOR (0 to 11);
			  target : in  STD_LOGIC_VECTOR (0 to 63);
           clock : in  STD_LOGIC;
           reset : in  STD_LOGIC;
			  enable : in std_logic;
           start : in  STD_LOGIC;
           ready : out  STD_LOGIC;
			  found : out std_logic
	 );
end crypt;

architecture Behavioral of crypt is

	COMPONENT des56salt
	PORT(
		key : IN std_logic_vector(0 to 55);
		load : in std_logic;
		salt : IN std_logic_vector(0 to 11);
		clock : IN std_logic;
		reset : IN std_logic;          
		result : OUT std_logic_vector(0 to 63);
		ready2 : out std_logic
		);
	END COMPONENT;
	
	signal desResult : std_logic_vector(0 to 63);
	signal wordMatch : std_logic_vector(3 downto 0);
	signal desReady, load, readyBuffer : std_logic;
	signal round : integer range 0 to 25;

begin

	Inst_des56salt: des56salt PORT MAP(
		key => key,
		load => load,
		salt => salt,
		clock => clock,
		reset => reset,
		result => desResult,
		ready2 => desReady
	);
	load <= start and enable;
	
	ready <= readyBuffer;
	
	-- control logic
	process(clock, reset)
	begin
		if reset = '1' then
			readyBuffer <= '0';
			round <= 0;
			
		elsif (rising_edge(clock)) then
			readyBuffer <= '0';
			
			if round = 0 then
				if load = '1' then
					round <= round + 1;
				else
					readyBuffer <= '1';
				end if;

			elsif round = 25 then
				if desReady = '1' then
					round <= 0;
				end if;

			else
				if desReady = '1' then
					round <= round + 1;
				end if;

			end if;

		end if;
	end process;

	-- handle outputs
	process(clock)
		variable tmp : std_logic;
	begin
		if rising_edge(clock) then

			-- compare result with target word wise in first stage
			for i in 0 to 3 loop
				if target(16 * i to 16 * i + 15) = desResult(16 * i to 16 * i + 15) then
					wordMatch(i) <= '1';
				else
					wordMatch(i) <= '0';
				end if;
			end loop;

			-- check if all bytes matched in second stage
			tmp := readyBuffer;
			for i in 0 to 3 loop
				tmp := tmp and wordMatch(i);
			end loop;
			found <= tmp;

		end if;
	end process;
	
end Behavioral;

